///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   DECZMSG.C - Decode Zodiac Message
// 
//
//   DESCRIPTION
//
//   Function to dispatch Zodiac message decoding to the appropriate decode
//   routine.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\DECZMSG.C_v  $
//   
//      Rev 1.19   15 Dec 1999 14:22:20   phungh
//   Take out msg1192, Add msg1092 to 
//   accommodate the msg ID change in the 
//   zodiac software version 2.57
//   
//      Rev 1.18   08 Dec 1999 16:08:56   phungh
//   Add decoding for message 1106, 1137,
//   1191, 1192.  
//   
//      Rev 1.17   27 Apr 1999 15:08:22   phungh
//   labmon55 : Modification for AMD flash
//   download.  Add decoding for msg 1180
//   
//      Rev 1.16   21 Apr 1999 11:32:12   phungh
//   Labmon54: Add message decoding for 
//   1050 and 1051
//   
//      Rev 1.15   09 Nov 1998 10:26:42   phungh
//   labmon51: Fix file logging and missing 
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of
//   time spent too long in the interrupt handler
//   
//      Rev 1.13   Jul 06 1998 09:07:40   BANHND
//   added more DR features
//   
//      Rev 1.10   Jul 09 1997 09:44:52   COLEJ
//   Multiple Changes...
//   
//      Rev 1.9   Feb 25 1997 14:23:28   COLEJ
//   Added msg 1117 
//   
//      Rev 1.8   Feb 12 1997 16:04:58   COLEJ
//    
//   
//      Rev 1.7   Nov 14 1996 11:25:06   COLEJ
//    
//   
//      Rev 1.6   Sep 05 1996 11:49:04   COLEJ
//    
//   
//      Rev 1.5   Sep 03 1996 12:46:16   COLEJ
//    
//   
//      Rev 1.4   Aug 14 1996 11:53:00   COLEJ
//    
//   
//      Rev 1.3   Aug 14 1996 11:38:36   COLEJ
//   Added check that UTC TIME display is correct.
//   
//   
//   
//      Rev 1.1   Aug 13 1996 15:45:10   COLEJ
//   Added msg1108 processing - conditional usage of msg1000, msg1001, and msg1108 for UTC TIME.
//   Added FXTRACT feature.
//   Changed SETTIME location on screen.
//   
//   
//      Rev 1.0   13 May 1996 14:52:28   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <conio.h>
#include <graph.h>
#include <string.h>

#include "gentypes.h"                 
#include "gencons.h"
#include "labmon.h"
#include "display.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   
#include "monshow.h"


tBOOL              MSG1108ON = FALSE;      // this flag is used to signal that 1108 messages are being received
unsigned short     count1108 = 0;          // counter used to delay switching from 1108 to 1000 & 1001

void          clear_message_line  (void);
//extern short  MainTextColor;
//extern short  MainDataColor; 

extern unsigned long  Cnt1000, Cnt1001, Cnt1002, Cnt1003;
extern unsigned long  Cnt1005, Cnt1007, Cnt1008, Cnt1009, Cnt1011, Cnt1012;
extern unsigned long  Cnt1040, Cnt1041, Cnt1042, Cnt1050, Cnt1051;
extern unsigned long  Cnt1070, Cnt1071, Cnt1072, Cnt1075, Cnt1090, Cnt1091, Cnt1092;
extern unsigned long  Cnt1100, Cnt1102, Cnt1106, Cnt1108, Cnt1110, Cnt1117, Cnt1130;
extern unsigned long  Cnt1135, Cnt1136, Cnt1137, Cnt1138, Cnt1150, Cnt1160, Cnt1170;
extern unsigned long  Cnt1171, Cnt1172, Cnt1173, Cnt1180, Cnt1190, Cnt1191;
extern unsigned long  Cnt1200, Cnt1208, Cnt1210, Cnt1211, Cnt1212;
extern unsigned long  Cnt1213, Cnt1214, Cnt1216, Cnt1217;
extern unsigned long  Cnt1219, Cnt1220, Cnt1221;
extern unsigned long  Cnt1300, Cnt1303, Cnt1304, Cnt1305, Cnt1310, Cnt1330;
extern unsigned long  Cnt1331, Cnt1334, Cnt1350, Cnt1360, Cnt1392;
 
//extern short xtract;
extern short fxtract;

extern tBOOL DEBUG; 
extern tBOOL Flag1102;
extern tBOOL Display1070;
extern unsigned char tx_buff[MAX_TX_BUFFER]; //+1];  //?
extern short FlashMode;  

// Decode Zodiac Message
tBOOL DecZMsg(tMSGBUF *ZMsgBuf, tZMSG ZMsg)                
{
   char           Buf[80] = "";
   unsigned short MsgNum  = 0;
   unsigned short AckNack = 0;  
   tULONG         SetTime;              

   extern short   BITTest;
  
   // message number
   GetUShort(&MsgNum, ZMsgBuf, 2); 
 
   // message ack/nack processing
   GetUShort(&AckNack, ZMsgBuf, 4);
   if(AckNack & (A_BIT | N_BIT)){ 
      // ack/nack request/response in message
      if(AckNack & R_BIT){   
         // ack/nack request in message
      }
      else{ 
         // ack/nack response message
         if(AckNack & A_BIT){   
            sprintf(Buf,"%4d  ACK ", MsgNum); 
         }
         else{
            sprintf(Buf,"%4d NACK ", MsgNum);
         }
         ShowText(Buf,MSGR, MSGC);
         return TRUE;
      } 
   } 

   
   // do not display messages while BIT screen is up
   if(BITTest && (MsgNum != 1100)){
      return TRUE;
   }
   
   // do not decode and display most messages during extraction 
   if(fxtract && (MsgNum != 1102)){
      return TRUE;
   }
   
   
   // decode and display message data
   if (MsgNum/100 == 10 || MsgNum/100 == 11) {
     GetULong(&SetTime, ZMsgBuf, 6);   
     sprintf(Buf,"%8lu",SetTime);
     ShowText(Buf,TIMR+ 5,TIMC+ 9);
   }

   switch(MsgNum){
      // NE output messages      
      case 1000: 
         if( MSG1108ON )
           if( count1108 == 0 )      //test for clearing 1108 flag
             MSG1108ON = FALSE;
           else
             count1108--;
             
         memcpy(&ZMsg.Msg1000, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1000));
         Dec1000(ZMsgBuf, &ZMsg.Msg1000);
         Show1000(&ZMsg.Msg1000);
         Cnt1000++;
         break;    
      case 1001: 
         if( MSG1108ON )
           if( count1108 == 0 )      //test for clearing 1108 flag
             MSG1108ON = FALSE;
           else
             count1108--;
             
         memcpy(&ZMsg.Msg1001, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1001));
         Dec1001(ZMsgBuf, &ZMsg.Msg1001);
         Show1001(&ZMsg.Msg1001);
         Cnt1001++;
         break;    
      case 1002:          
         memcpy(&ZMsg.Msg1002, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1002));
         Dec1002(ZMsgBuf, &ZMsg.Msg1002);
         Show1002(&ZMsg.Msg1002); 
         Cnt1002++; 
         break;
      case 1003: 
         memcpy(&ZMsg.Msg1003, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1003));
         Dec1003(ZMsgBuf, &ZMsg.Msg1003);
         Show1003(&ZMsg.Msg1003); 
         Cnt1003++; 
         break;
      case 1005:
         memcpy(&ZMsg.Msg1005, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1005));
         Dec1005(ZMsgBuf, &ZMsg.Msg1005);
         Show1005(&ZMsg.Msg1005);
         Cnt1005++;
         break;
      case 1007: 
         memcpy(&ZMsg.Msg1007, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1007));
         Dec1007(ZMsgBuf, &ZMsg.Msg1007); 
         Cnt1007++; 
         break;           
      case 1008: 
         memcpy(&ZMsg.Msg1008, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1008));
         Dec1008(ZMsgBuf, &ZMsg.Msg1008); 
         Show1008(&ZMsg.Msg1008);
         Cnt1008++;
         break;           
      case 1009: 
         memcpy(&ZMsg.Msg1009, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1009));
         Dec1009(ZMsgBuf, &ZMsg.Msg1009);
         Show1009(&ZMsg.Msg1009);
         Cnt1009++;
         break;    
      case 1011: 
         memcpy(&ZMsg.Msg1011, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1011));
         Dec1011(ZMsgBuf, &ZMsg.Msg1011); 
         Show1011(&ZMsg.Msg1011); 
         Cnt1011++;
         break;
      case 1012: 
         memcpy(&ZMsg.Msg1012, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1012));
         Dec1012(ZMsgBuf, &ZMsg.Msg1012); 
         Show1012(&ZMsg.Msg1012); 
         Cnt1012++; 
         break;           
      case 1040: 
         memcpy(&ZMsg.Msg1040, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1040));
         Dec1040(ZMsgBuf, &ZMsg.Msg1040); 
         //Show1040(&ZMsg.Msg1040); 
         Cnt1040++; 
         break;           
      case 1041: 
         memcpy(&ZMsg.Msg1041, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1041));
         Dec1041(ZMsgBuf, &ZMsg.Msg1041); 
         //Show1041(&ZMsg.Msg1041); 
         Cnt1041++; 
         break;           
      case 1042: 
         memcpy(&ZMsg.Msg1042, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1042));
         Dec1042(ZMsgBuf, &ZMsg.Msg1042); 
         //Show1042(&ZMsg.Msg1042); 
         Cnt1042++; 
         break;           
      case 1050:
     	 memcpy(&ZMsg.Msg1050, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1050));
//      	 Dec1050(ZMsgBuf, &ZMsg.Msg1050);
      	 Show1050(&ZMsg.Msg1050);
      	 Cnt1050++;
      	 break;
      case 1051:
    	 memcpy(&ZMsg.Msg1051, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1051));
//      	 Dec1051(ZMsgBuf, &ZMsg.Msg1051);
      	 Show1051(&ZMsg.Msg1051);
      	 Cnt1051++;
      	 break;
      case 1070:
         if (Display1070) {
           memcpy(&ZMsg.Msg1070, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1070));
           //Dec1070(ZMsgBuf, &ZMsg.Msg1070); 
           Show1070(&ZMsg.Msg1070); 
         }
         Cnt1070++; 
         break;           
                                           
      case 1071: 
         memcpy(&ZMsg.Msg1071, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1071));
         Dec1071(ZMsgBuf, &ZMsg.Msg1071); 
         //Show1071(&ZMsg.Msg1071); 
         Cnt1071++; 
         break;           
                                           
      case 1072: 
         memcpy(&ZMsg.Msg1072, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1072));
         Dec1072(ZMsgBuf, &ZMsg.Msg1072); 
         //Show1072(&ZMsg.Msg1072); 
         Cnt1072++; 
         break;           
                                           
      case 1075: 
         memcpy(&ZMsg.Msg1075, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1075));
         //Dec1075(ZMsgBuf, &ZMsg.Msg1075); 
         Show1075(&ZMsg.Msg1075); 
         Cnt1075++; 
         break;           

      case 1090: 
         //memcpy(&ZMsg.Msg1090, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1090));
         //Dec1090(ZMsgBuf, &ZMsg.Msg1090); 
         //Show1090(&ZMsg.Msg1090); 
         Cnt1090++; 
         break;           

      case 1091: 
         //memcpy(&ZMsg.Msg1091, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1091));
         //Dec1091(ZMsgBuf, &ZMsg.Msg1091); 
         //Show1091(&ZMsg.Msg1091); 
         Cnt1091++; 
         break;           

      case 1092:
         // message 1070 and 1092 occupy the same area on the screen
      	 if(!Display1070) { 
         	memcpy(&ZMsg.Msg1092, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1092));
//         Dec1092(ZMsgBuf, &ZMsg.Msg1092); 
         	Show1092(&ZMsg.Msg1092);
         }
         Cnt1092++; 
         break;   
                                           
      // ME output messages          
      case 1100:
         memcpy(&ZMsg.Msg1100, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1100));
         Dec1100(ZMsgBuf, &ZMsg.Msg1100);
         Show1100(&ZMsg.Msg1100); 
         Cnt1100++; 
         break;     
      case 1101:
         break;     
      case 1102:
         if(DEBUG){ 
           memcpy(&ZMsg.Msg1102, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1102)); 
           Show1102(&ZMsg.Msg1102);  
           Cnt1102++;
         }
         else{
           memset(&ZMsg.ZQuery, 0, sizeof(ZMsg.ZQuery));
           ZMsg.ZQuery.MsgID       = 1102;
           ZMsg.ZQuery.MsgFlags    = 0x8700;
           BldZQuery(ZMsgBuf, &ZMsg.ZQuery);
           memcpy(tx_buff, ZMsgBuf, sizeof(ZMsg.ZQuery) + HDR_LEN);
           send_msg(tx_buff);
         }
         break;
      case 1106: 
         memcpy(&ZMsg.Msg1106, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1106));
         Dec1106(ZMsgBuf, &ZMsg.Msg1106); 
         Show1106(&ZMsg.Msg1106);
         Cnt1106++;
         break;    
      case 1108: 
         memcpy(&ZMsg.Msg1108, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1108));
         Show1108(&ZMsg.Msg1108);
         Cnt1108++;
         count1108 = 2;     // set countdown counter
         break;    
      case 1110: 
         memcpy(&ZMsg.Msg1110, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1110));
         Dec1110(ZMsgBuf, &ZMsg.Msg1110); 
         Show1110(&ZMsg.Msg1110); 
         Cnt1110++;
         break;    
      case 1117: 
         memcpy(&ZMsg.Msg1117, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1117));
         Dec1117(ZMsgBuf, &ZMsg.Msg1117); 
         Show1117(&ZMsg.Msg1117); 
         Cnt1117++;
         break;    
      case 1130: 
         memcpy(&ZMsg.Msg1130, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1130));
         Dec1130(ZMsgBuf, &ZMsg.Msg1130); 
         Show1130(&ZMsg.Msg1130);
         Cnt1130++;
         break;     
      case 1135: 
         memcpy(&ZMsg.Msg1135, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1135));
         Dec1135(ZMsgBuf, &ZMsg.Msg1135); 
         Show1135(&ZMsg.Msg1135);
         Cnt1135++;
         break;        
      case 1136: 
         memcpy(&ZMsg.Msg1136, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1136));
         Dec1136(ZMsgBuf, &ZMsg.Msg1136); 
         Show1136(&ZMsg.Msg1136);
         Cnt1136++;
         break;                                
      case 1137: 
         memcpy(&ZMsg.Msg1137, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1137));
         Dec1137(ZMsgBuf, &ZMsg.Msg1137); 
         Show1137(&ZMsg.Msg1137);
         Cnt1137++;
         break;                                
      case 1150:
//      	 memcpy(&ZMsg.Msg1150, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1150));
//      	 Dec1150(ZMsgBuf, &ZMsg.Msg1150);
      	 Cnt1150++;
      	 break;
      case 1160: 
         memcpy(&ZMsg.Msg1160, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1160));
         Dec1160(ZMsgBuf, &ZMsg.Msg1160); 
         Show1160(&ZMsg.Msg1160);
         Cnt1160++; 
         break;   
      case 1170: 
         memcpy(&ZMsg.Msg1170, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1170));
         Dec1170(ZMsgBuf, &ZMsg.Msg1170); 
         Show1170(&ZMsg.Msg1170);
         Cnt1170++; 
         break;   
      case 1171: 
         memcpy(&ZMsg.Msg1171, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1171));
         Dec1171(ZMsgBuf, &ZMsg.Msg1171); 
         Show1171(&ZMsg.Msg1171);
         Cnt1171++; 
         break;   
      case 1172: 
         memcpy(&ZMsg.Msg1172, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1172));
         Dec1172(ZMsgBuf, &ZMsg.Msg1172); 
         Show1172(&ZMsg.Msg1172);
         Cnt1172++; 
         break;   
      case 1173: 
         memcpy(&ZMsg.Msg1173, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1173));
         Show1173(&ZMsg.Msg1173);
         Cnt1173++; 
         break;   
      case 1180:
            memcpy(&ZMsg.Msg1180, ((tSHORT *) ZMsgBuf)+5, sizeof(ZMsg.Msg1180));
            // Dec1180(ZMsgBuf, &ZMsg.Msg1180); 
            Show1180(&ZMsg.Msg1180);
            Cnt1180++; 
         break;   
      case 1190: 
         memcpy(&ZMsg.Msg1190, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1190));
         Dec1190(ZMsgBuf, &ZMsg.Msg1190); 
         Show1190(&ZMsg.Msg1190);
         Cnt1190++; 
         break;   
      case 1191:
      	 if(!Flag1102) { 
         	memcpy(&ZMsg.Msg1191, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1191));
         	Dec1191(ZMsgBuf, &ZMsg.Msg1191); 
            Show1191(&ZMsg.Msg1191);
		 }
         Cnt1191++; 
         break;   
//take out because of msgID changed 1192->1092      case 1192:
         // message 1070 and 1192 occupy the same area on the screen
//      	 if(!Display1070) { 
//         	memcpy(&ZMsg.Msg1192, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1192));
//         Dec1192(ZMsgBuf, &ZMsg.Msg1192); 
//         	Show1192(&ZMsg.Msg1192);
//         }
//         Cnt1192++; 
//         break;   
      case 1200: 
         memcpy(&ZMsg.Msg1200, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1200));
         Dec1200(ZMsgBuf, &ZMsg.Msg1200); 
         Cnt1200++; 
         break;
      case 1208: 
         memcpy(&ZMsg.Msg1208, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1208));
         Dec1208(ZMsgBuf, &ZMsg.Msg1208); 
         Cnt1208++; 
         break;
      case 1210: 
         memcpy(&ZMsg.Msg1210, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1210));
         Dec1210(ZMsgBuf, &ZMsg.Msg1210);
         Cnt1210++; 
         break;   
      case 1211: 
         memcpy(&ZMsg.Msg1211, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1211));
         Dec1211(ZMsgBuf, &ZMsg.Msg1211); 
         Cnt1211++;
         break; 
      case 1212: 
         memcpy(&ZMsg.Msg1212, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1212));
         Dec1212(ZMsgBuf, &ZMsg.Msg1212); 
         Cnt1212++; 
         break;   
      case 1213: 
         memcpy(&ZMsg.Msg1213, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1213));
         Dec1213(ZMsgBuf, &ZMsg.Msg1213); 
         Cnt1213++;
         break;   
      case 1214: 
         memcpy(&ZMsg.Msg1214, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1214));
         Dec1214(ZMsgBuf, &ZMsg.Msg1214); 
         Cnt1214++; 
         break;
      case 1216: 
         memcpy(&ZMsg.Msg1216, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1216));
         Dec1216(ZMsgBuf, &ZMsg.Msg1216); 
         Cnt1216++; 
         break;   
      case 1217: 
         memcpy(&ZMsg.Msg1217, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1217));
         Dec1217(ZMsgBuf, &ZMsg.Msg1217); 
         Cnt1217++; 
         break;   
      case 1219: 
         memcpy(&ZMsg.Msg1219, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1219));
         Dec1219(ZMsgBuf, &ZMsg.Msg1219); 
         Cnt1219++; 
         break;   
      case 1220: 
         memcpy(&ZMsg.Msg1220, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1220));
         Dec1220(ZMsgBuf, &ZMsg.Msg1220); 
         Cnt1220++; 
         break;            
  
      // ME input messages 
      case 1300: 
         memcpy(&ZMsg.Msg1300, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1300));
         Dec1300(ZMsgBuf, &ZMsg.Msg1300); 
         Cnt1300++; 
         break;
      case 1303: 
         memcpy(&ZMsg.Msg1303, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1303));
         Dec1303(ZMsgBuf, &ZMsg.Msg1303); 
         Cnt1303++; 
         break;   
      case 1310: 
         memcpy(&ZMsg.Msg1310, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1310));
         Dec1310(ZMsgBuf, &ZMsg.Msg1310); 
         Cnt1310++;
         break;
      case 1330: 
         memcpy(&ZMsg.Msg1330, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1330));
         Dec1330(ZMsgBuf, &ZMsg.Msg1330); 
         Cnt1330++;
         break;  
      case 1331: 
         memcpy(&ZMsg.Msg1331, ((tSHORT *) ZMsgBuf)+7, sizeof(ZMsg.Msg1331));
         Dec1331(ZMsgBuf, &ZMsg.Msg1331); 
         Cnt1331++;
         break;  

      // message type not supported 
      default:      
         clear_message_line();      
         sprintf(Buf, " UNSUPPORTED BINARY MESSAGE %04d", MsgNum);
         ShowText(Buf, CMDR, CMDC);
         return FALSE; 
   }
   return TRUE;
}
